"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EquivalentApiRequest = EquivalentApiRequest;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _process_slo_form_values = require("../../helpers/process_slo_form_values");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EquivalentApiRequest({
  disabled,
  isEditMode,
  slo
}) {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    getValues,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const [sloData, setSloData] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!isFlyoutVisible) {
      return;
    }
    trigger().then(isValid => {
      if (isValid) {
        setSloData((0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(getValues()));
      }
    });
  }, [getValues, trigger, isFlyoutVisible]);
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: () => setIsFlyoutVisible(false)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.h2.equivalentAPIRequestToLabel', {
      defaultMessage: 'Equivalent API request'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.equivalentApiRequest.p.useTheRESTAPILabel",
      defaultMessage: "Use the REST API"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "javascript",
      isCopyable: true,
      paddingSize: "s"
    }, isEditMode ? `PUT /api/observability/slos/${slo.id}` : 'POST /api/observability/slos'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.equivalentApiRequest.p.withTheFollowingBodyLabel",
      defaultMessage: "with the following body:"
    })), sloData ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      paddingSize: "s"
    }, JSON.stringify(sloData, null, 2)) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "javascript",
      isCopyable: true,
      paddingSize: "s"
    }, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.formIsNotValidCodeBlockLabel', {
      defaultMessage: 'Form is not valid'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yEquivalentApiRequestCloseButton",
      iconType: "cross",
      onClick: () => setIsFlyoutVisible(false),
      flush: "left"
    }, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.closeButtonEmptyLabel', {
      defaultMessage: 'Close'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "copyClipboard",
    "data-test-subj": "sloFormCopyJsonButton",
    disabled: disabled,
    onClick: () => setIsFlyoutVisible(true)
  }, _i18n.i18n.translate('xpack.slo.sloEdit.equivalentApiRequest', {
    defaultMessage: 'Equivalent API request'
  })), flyout);
}