"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOGroupingValueSelector = SLOGroupingValueSelector;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _paths = require("../../../../../common/locators/paths");
var _use_fetch_slo_instances = require("../../hooks/use_fetch_slo_instances");
var _use_get_query_params = require("../../hooks/use_get_query_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOGroupingValueSelector({
  slo,
  groupingKey,
  value
}) {
  const isAvailable = window.location.pathname.includes(_paths.SLOS_BASE_PATH);
  const {
    search: searchParams
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    remoteName
  } = (0, _use_get_query_params.useGetQueryParams)();
  const [currentValue, setCurrentValue] = (0, _react2.useState)(value);
  const [options, setOptions] = (0, _react2.useState)([]);
  const [search, setSearch] = (0, _react2.useState)(undefined);
  const [debouncedSearch, setDebouncedSearch] = (0, _react2.useState)(undefined);
  (0, _useDebounce.default)(() => setDebouncedSearch(search), 500, [search]);
  const {
    isLoading,
    isError,
    data
  } = (0, _use_fetch_slo_instances.useFetchSloGroupings)({
    sloId: slo.id,
    groupingKey,
    instanceId: slo.instanceId,
    search: debouncedSearch,
    remoteName
  });
  (0, _react2.useEffect)(() => {
    if (data) {
      setSearch(undefined);
      setDebouncedSearch(undefined);
      setOptions(data.values.map(toField));
    }
  }, [data]);
  const onChange = selected => {
    const newValue = selected[0].value;
    if (!newValue) return;
    setCurrentValue(newValue);
    const urlSearchParams = new URLSearchParams(searchParams);
    const newGroupings = {
      ...slo.groupings,
      [groupingKey]: newValue
    };
    urlSearchParams.set('instanceId', toInstanceId(newGroupings, slo.groupBy));
    history.replace({
      search: urlSearchParams.toString()
    });
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    css: (0, _react.css)`
          max-width: 500px;
        `,
    isClearable: false,
    compressed: true,
    prepend: groupingKey,
    append: currentValue ? /*#__PURE__*/_react2.default.createElement(_eui.EuiCopy, {
      textToCopy: currentValue
    }, copy => /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "sloSLOGroupingValueSelectorButton",
      color: "text",
      iconType: "copyClipboard",
      onClick: copy,
      "aria-label": _i18n.i18n.translate('xpack.slo.sLOGroupingValueSelector.copyButton.label', {
        defaultMessage: 'Copy value to clipboard'
      })
    })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "sloSLOGroupingValueSelectorButton",
      color: "text",
      disabled: true,
      iconType: "copyClipboard",
      "aria-label": _i18n.i18n.translate('xpack.slo.sLOGroupingValueSelector.copyButton.noValueLabel', {
        defaultMessage: 'Select a value before'
      })
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    isLoading: isLoading,
    isDisabled: isError || !isAvailable,
    placeholder: _i18n.i18n.translate('xpack.slo.sLOGroupingValueSelector.placeholder', {
      defaultMessage: 'Select a group value'
    }),
    selectedOptions: currentValue ? [toField(currentValue)] : [],
    onChange: onChange,
    truncationProps: {
      truncation: 'end'
    },
    onSearchChange: searchValue => {
      if (searchValue !== '') {
        setSearch(searchValue);
      }
    }
  }));
}
function toField(value) {
  return {
    label: value,
    value
  };
}
function toInstanceId(groupings, groupBy) {
  const groups = [groupBy].flat();
  return groups.map(group => groupings[group]).join(',');
}