"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/observability-plugin/common");
var _common2 = require("@kbn/slo-schema/src/schema/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SloDetailsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloDetailsLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      sloId,
      instanceId
    }) => {
      const queryParams = !!instanceId && instanceId !== _common2.ALL_VALUE ? `?instanceId=${encodeURIComponent(instanceId)}` : '';
      const path = !!sloId ? `/${encodeURIComponent(sloId)}${queryParams}` : '/';
      return {
        app: 'slo',
        path,
        state: {}
      };
    });
  }
}
exports.SloDetailsLocatorDefinition = SloDetailsLocatorDefinition;