"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchGroupByCardinality = useFetchGroupByCardinality;
var _react = require("react");
var _lodash = require("lodash");
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _parse_kuery = require("../../common/parse_kuery");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HIGH_CARDINALITY_THRESHOLD = 1000;
const buildInstanceId = groupBy => {
  const groups = [groupBy].flat().filter(value => !!value);
  const groupings = groups.map(group => `'${group}:'+doc['${group}'].value`).join(`+'|'+`);
  const hasAllGroupings = groups.map(group => `doc['${group}'].size() > 0`).join(' && ');
  return `if (${hasAllGroupings}) { emit(${groupings}) }`;
};
function useFetchGroupByCardinality(indexPattern, timestampField = '@timestamp', groupBy, filters) {
  const {
    data: dataService
  } = (0, _use_kibana.useKibana)().services;
  const serializedFilters = JSON.stringify(filters);
  const [filtersState, setFiltersState] = (0, _react.useState)(serializedFilters);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const store = (0, _react.useCallback)((0, _lodash.debounce)(value => setFiltersState(value), 800), []);
  (0, _react.useEffect)(() => {
    if (filtersState !== serializedFilters) {
      store(serializedFilters);
    }
  }, [filtersState, serializedFilters, store]);
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchGroupByCardinality', indexPattern, timestampField, groupBy, filters],
    queryFn: async ({
      signal
    }) => {
      try {
        var _result$rawResponse$a, _result$rawResponse, _result$rawResponse$a2, _result$rawResponse$a3;
        const result = await (0, _rxjs.lastValueFrom)(dataService.search.search({
          params: {
            index: indexPattern,
            body: {
              query: {
                bool: {
                  filter: [{
                    range: {
                      [timestampField]: {
                        gte: 'now-24h'
                      }
                    }
                  }, (0, _parse_kuery.getElasticsearchQueryOrThrow)(filters)]
                }
              },
              runtime_mappings: {
                group_combinations: {
                  type: 'keyword',
                  script: buildInstanceId(groupBy)
                }
              },
              aggs: {
                groupByCardinality: {
                  cardinality: {
                    field: 'group_combinations'
                  }
                }
              }
            }
          }
        }));

        // @ts-expect-error Property 'value' does not exist on type 'AggregationsAggregate'
        const cardinality = (_result$rawResponse$a = (_result$rawResponse = result.rawResponse) === null || _result$rawResponse === void 0 ? void 0 : (_result$rawResponse$a2 = _result$rawResponse.aggregations) === null || _result$rawResponse$a2 === void 0 ? void 0 : (_result$rawResponse$a3 = _result$rawResponse$a2.groupByCardinality) === null || _result$rawResponse$a3 === void 0 ? void 0 : _result$rawResponse$a3.value) !== null && _result$rawResponse$a !== void 0 ? _result$rawResponse$a : 0;
        return {
          cardinality,
          isHighCardinality: cardinality > HIGH_CARDINALITY_THRESHOLD
        };
      } catch (error) {
        throw new Error(`Something went wrong. Error: ${error}`);
      }
    },
    retry: false,
    refetchOnWindowFocus: false,
    enabled: Boolean(indexPattern) && Boolean(timestampField) && Boolean(groupBy) && ![groupBy].flat().includes(_sloSchema.ALL_VALUE)
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data
  };
}