"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewModeSelector = OverviewModeSelector;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewModeOptions = [{
  id: `single`,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddable.typeSelector.singleSLOLabel",
    defaultMessage: "Single SLO"
  })
}, {
  id: `groups`,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddable.typeSelector.groupSLOLabel",
    defaultMessage: "Grouped SLOs"
  })
}];
function OverviewModeSelector({
  value,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.overviewEmbeddable.viewTypeLabel', {
      defaultMessage: 'View type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "sloOverviewModeSelector",
    isFullWidth: true,
    legend: "This is a basic group",
    options: overviewModeOptions,
    idSelected: value,
    onChange: onChange
  }));
}