"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataTimeRange = getDataTimeRange;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alert = require("./alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDataTimeRange(alert) {
  const timeRange = alert.fields[_ruleDataUtils.ALERT_TIME_RANGE];
  const actionGroupWindow = (0, _alert.getActionGroupWindow)(alert);
  const windowDurationInMs = actionGroupWindow.longWindow.value * 60 * 60 * 1000;
  return {
    from: new Date(new Date(timeRange.gte).getTime() - windowDurationInMs),
    to: timeRange.lte ? new Date(timeRange.lte) : new Date()
  };
}