"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWildcardTransformId = exports.getWildcardPipelineId = exports.getSLOTransformId = exports.getSLOSummaryTransformId = exports.getSLOSummaryPipelineId = exports.getSLOPipelineId = exports.SYNTHETICS_INDEX_PATTERN = exports.SYNTHETICS_DEFAULT_GROUPINGS = exports.SUPPRESSED_PRIORITY_ACTION_ID = exports.SUPPRESSED_PRIORITY_ACTION = exports.SUMMARY_TEMP_INDEX_NAME = exports.SUMMARY_INDEX_TEMPLATE_PATTERN = exports.SUMMARY_INDEX_TEMPLATE_NAME = exports.SUMMARY_DESTINATION_INDEX_PATTERN = exports.SUMMARY_DESTINATION_INDEX_NAME = exports.SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.SLO_RESOURCES_VERSION_MAJOR = exports.SLO_RESOURCES_VERSION = exports.SLO_MODEL_VERSION = exports.SLI_INGEST_PIPELINE_INDEX_NAME_PREFIX = exports.SLI_INDEX_TEMPLATE_PATTERN = exports.SLI_INDEX_TEMPLATE_NAME = exports.SLI_DESTINATION_INDEX_PATTERN = exports.SLI_DESTINATION_INDEX_NAME = exports.SLI_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SLI_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.MEDIUM_PRIORITY_ACTION_ID = exports.MEDIUM_PRIORITY_ACTION = exports.LOW_PRIORITY_ACTION_ID = exports.LOW_PRIORITY_ACTION = exports.LOCK_ID_RESOURCE_INSTALLER = exports.INVALID_EQUATION_REGEX = exports.HIGH_PRIORITY_ACTION_ID = exports.HIGH_PRIORITY_ACTION = exports.DEFAULT_STALE_SLO_THRESHOLD_HOURS = exports.DEFAULT_SLO_PAGE_SIZE = exports.DEFAULT_SLO_GROUPS_PAGE_SIZE = exports.ALERT_ACTION_ID = exports.ALERT_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_EQUATION_REGEX = exports.INVALID_EQUATION_REGEX = /[^A-Z|+|\-|\s|\d+|\.|\(|\)|\/|\*|>|<|=|\?|\:|&|\!|\|]+/g;
const ALERT_ACTION_ID = exports.ALERT_ACTION_ID = 'slo.burnRate.alert';
const ALERT_ACTION = exports.ALERT_ACTION = {
  id: ALERT_ACTION_ID,
  name: _i18n.i18n.translate('xpack.slo.alerting.burnRate.alertAction', {
    defaultMessage: 'Critical'
  }),
  severity: {
    level: 3
  }
};
const HIGH_PRIORITY_ACTION_ID = exports.HIGH_PRIORITY_ACTION_ID = 'slo.burnRate.high';
const HIGH_PRIORITY_ACTION = exports.HIGH_PRIORITY_ACTION = {
  id: HIGH_PRIORITY_ACTION_ID,
  name: _i18n.i18n.translate('xpack.slo.alerting.burnRate.highPriorityAction', {
    defaultMessage: 'High'
  }),
  severity: {
    level: 2
  }
};
const MEDIUM_PRIORITY_ACTION_ID = exports.MEDIUM_PRIORITY_ACTION_ID = 'slo.burnRate.medium';
const MEDIUM_PRIORITY_ACTION = exports.MEDIUM_PRIORITY_ACTION = {
  id: MEDIUM_PRIORITY_ACTION_ID,
  name: _i18n.i18n.translate('xpack.slo.alerting.burnRate.mediumPriorityAction', {
    defaultMessage: 'Medium'
  }),
  severity: {
    level: 1
  }
};
const LOW_PRIORITY_ACTION_ID = exports.LOW_PRIORITY_ACTION_ID = 'slo.burnRate.low';
const LOW_PRIORITY_ACTION = exports.LOW_PRIORITY_ACTION = {
  id: LOW_PRIORITY_ACTION_ID,
  name: _i18n.i18n.translate('xpack.slo.alerting.burnRate.lowPriorityAction', {
    defaultMessage: 'Low'
  }),
  severity: {
    level: 0
  }
};
const SUPPRESSED_PRIORITY_ACTION_ID = exports.SUPPRESSED_PRIORITY_ACTION_ID = 'slo.burnRate.suppressed';
const SUPPRESSED_PRIORITY_ACTION = exports.SUPPRESSED_PRIORITY_ACTION = {
  id: SUPPRESSED_PRIORITY_ACTION_ID,
  name: _i18n.i18n.translate('xpack.slo.alerting.burnRate.suppressedPriorityAction', {
    defaultMessage: 'Suppressed'
  })
};
const LOCK_ID_RESOURCE_INSTALLER = exports.LOCK_ID_RESOURCE_INSTALLER = 'slo:resource_installer';
const SLO_MODEL_VERSION = exports.SLO_MODEL_VERSION = 2;
const SLO_RESOURCES_VERSION = exports.SLO_RESOURCES_VERSION = 3.5;
const SLO_RESOURCES_VERSION_MAJOR = exports.SLO_RESOURCES_VERSION_MAJOR = 3;
const SLI_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.SLI_COMPONENT_TEMPLATE_MAPPINGS_NAME = '.slo-observability.sli-mappings';
const SLI_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SLI_COMPONENT_TEMPLATE_SETTINGS_NAME = '.slo-observability.sli-settings';
const SLI_INDEX_TEMPLATE_NAME = exports.SLI_INDEX_TEMPLATE_NAME = '.slo-observability.sli';
const SLI_INDEX_TEMPLATE_PATTERN = exports.SLI_INDEX_TEMPLATE_PATTERN = `.slo-observability.sli-*`;
const SLI_DESTINATION_INDEX_NAME = exports.SLI_DESTINATION_INDEX_NAME = `.slo-observability.sli-v${SLO_RESOURCES_VERSION}`;
const SLI_DESTINATION_INDEX_PATTERN = exports.SLI_DESTINATION_INDEX_PATTERN = `.slo-observability.sli-v${SLO_RESOURCES_VERSION_MAJOR}*`;
const SLI_INGEST_PIPELINE_INDEX_NAME_PREFIX = exports.SLI_INGEST_PIPELINE_INDEX_NAME_PREFIX = `.slo-observability.sli-v${SLO_RESOURCES_VERSION}.`;
const SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = exports.SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME = '.slo-observability.summary-mappings';
const SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = exports.SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME = '.slo-observability.summary-settings';
const SUMMARY_INDEX_TEMPLATE_NAME = exports.SUMMARY_INDEX_TEMPLATE_NAME = '.slo-observability.summary';
const SUMMARY_INDEX_TEMPLATE_PATTERN = exports.SUMMARY_INDEX_TEMPLATE_PATTERN = `.slo-observability.summary-*`;
const SUMMARY_DESTINATION_INDEX_NAME = exports.SUMMARY_DESTINATION_INDEX_NAME = `.slo-observability.summary-v${SLO_RESOURCES_VERSION}`; // store the summary document generated by transform
const SUMMARY_TEMP_INDEX_NAME = exports.SUMMARY_TEMP_INDEX_NAME = `.slo-observability.summary-v${SLO_RESOURCES_VERSION}.temp`; // store the temporary summary document
const SUMMARY_DESTINATION_INDEX_PATTERN = exports.SUMMARY_DESTINATION_INDEX_PATTERN = `.slo-observability.summary-v${SLO_RESOURCES_VERSION_MAJOR}*`; // include temp and non-temp summary indices

const getSLOTransformId = (sloId, sloRevision) => `slo-${sloId}-${sloRevision}`;
exports.getSLOTransformId = getSLOTransformId;
const getSLOSummaryTransformId = (sloId, sloRevision) => `slo-summary-${sloId}-${sloRevision}`;
exports.getSLOSummaryTransformId = getSLOSummaryTransformId;
const getWildcardTransformId = (sloId, sloRevision) => `slo-*${sloId}-${sloRevision}`;
exports.getWildcardTransformId = getWildcardTransformId;
const getSLOPipelineId = (sloId, sloRevision) => `.slo-observability.sli.pipeline-${sloId}-${sloRevision}`;
exports.getSLOPipelineId = getSLOPipelineId;
const getSLOSummaryPipelineId = (sloId, sloRevision) => `.slo-observability.summary.pipeline-${sloId}-${sloRevision}`;
exports.getSLOSummaryPipelineId = getSLOSummaryPipelineId;
const getWildcardPipelineId = (sloId, sloRevision) => `.slo-observability.*.pipeline-${sloId}-${sloRevision}`;
exports.getWildcardPipelineId = getWildcardPipelineId;
const SYNTHETICS_INDEX_PATTERN = exports.SYNTHETICS_INDEX_PATTERN = 'synthetics-*';
const SYNTHETICS_DEFAULT_GROUPINGS = exports.SYNTHETICS_DEFAULT_GROUPINGS = ['monitor.name', 'observer.geo.name', 'monitor.id'];
const DEFAULT_STALE_SLO_THRESHOLD_HOURS = exports.DEFAULT_STALE_SLO_THRESHOLD_HOURS = 48;
const DEFAULT_SLO_PAGE_SIZE = exports.DEFAULT_SLO_PAGE_SIZE = 25;
const DEFAULT_SLO_GROUPS_PAGE_SIZE = exports.DEFAULT_SLO_GROUPS_PAGE_SIZE = 25;