"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeleteUnusedUrlsRoute = void 0;
var _server = require("@kbn/core/server");
var _task = require("./task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerDeleteUnusedUrlsRoute = ({
  router,
  core,
  urlExpirationDuration,
  urlLimit,
  logger,
  isEnabled
}) => {
  router.post({
    path: '/internal/unused_urls_task/run',
    security: {
      authz: {
        requiredPrivileges: [_server.ReservedPrivilegesSet.superuser]
      }
    },
    options: {
      access: 'internal',
      summary: 'Runs the unused URLs cleanup task'
    },
    validate: {}
  }, async (_ctx, _req, res) => {
    if (!isEnabled) {
      return res.forbidden({
        body: {
          message: 'Unused URLs cleanup task is disabled. Enable it in the configuration.'
        }
      });
    }
    const {
      deletedCount
    } = await (0, _task.runDeleteUnusedUrlsTask)({
      core,
      urlExpirationDuration,
      urlLimit,
      logger,
      isEnabled
    });
    return res.ok({
      body: {
        message: 'Unused URLs cleanup task has finished.',
        deletedCount
      }
    });
  });
};
exports.registerDeleteUnusedUrlsRoute = registerDeleteUnusedUrlsRoute;