"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewDisplayOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_OPTION_KEY = 'Timestamp';
const VERBOSE_MODE_OPTION_KEY = 'Verbose mode';
const TOOLTIP_SHOW_DELAY = 3000;
const TOOLTIP_HIDE_DELAY = 5000;
const VERBOSE_TOOLTIP_TITLE = _i18n.i18n.translate('xpack.sessionView.sessionViewToggle.sessionViewVerboseTipTitle', {
  defaultMessage: 'Some results may be hidden'
});
const VERBOSE_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.sessionView.sessionViewToggle.sessionViewVerboseTipContent', {
  defaultMessage: 'For a complete set of results, turn on Verbose mode.'
});
const SessionViewDisplayOptions = ({
  onChange,
  displayOptions,
  showVerboseSearchTooltip
}) => {
  const [isOptionDropdownOpen, setOptionDropdownOpen] = (0, _react.useState)(false);
  const styles = (0, _styles.useStyles)();
  const tooltipRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (tooltipRef.current) {
      setTimeout(() => {
        if (tooltipRef.current) {
          tooltipRef.current.onFocus();
          setTimeout(() => {
            if (tooltipRef.current) {
              tooltipRef.current.onBlur();
            }
          }, TOOLTIP_HIDE_DELAY);
        }
      }, TOOLTIP_SHOW_DELAY);
    }
  }, [showVerboseSearchTooltip]);
  const optionsList = (0, _react.useMemo)(() => [{
    label: _i18n.i18n.translate('xpack.sessionView.sessionViewToggle.sessionViewToggleOptionsTimestamp', {
      defaultMessage: 'Timestamp'
    }),
    key: TIMESTAMP_OPTION_KEY,
    checked: displayOptions !== null && displayOptions !== void 0 && displayOptions.timestamp ? 'on' : undefined
  }, {
    label: _i18n.i18n.translate('xpack.sessionView.sessionViewToggle.sessionViewToggleOptionsVerbosemode', {
      defaultMessage: 'Verbose mode'
    }),
    key: VERBOSE_MODE_OPTION_KEY,
    checked: displayOptions !== null && displayOptions !== void 0 && displayOptions.verboseMode ? 'on' : undefined,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.sessionView.sessionViewToggle.sessionViewToggleOptionsVerboseModeTooltips",
        defaultMessage: "Verbose mode displays all processes created in a session, including shell startup, shell completion, and forks caused by built-in commands"
      })
    })
  }], [displayOptions]);
  const toggleOptionButton = () => {
    setOptionDropdownOpen(!isOptionDropdownOpen);
  };
  const closeOptionButton = () => {
    setOptionDropdownOpen(false);
  };
  const OptionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "eye",
    display: displayOptions.verboseMode || displayOptions.timestamp ? 'fill' : 'empty',
    onClick: toggleOptionButton,
    size: "m",
    "aria-label": "Session view display option",
    "data-test-subj": "sessionView:sessionViewOptionButton"
  }));
  const handleSelect = options => {
    const updateOptionState = options.reduce((chosenOptionStates, listedOptionStates) => {
      if (listedOptionStates.key === TIMESTAMP_OPTION_KEY) {
        chosenOptionStates.timestamp = listedOptionStates.checked === 'on';
      } else if (listedOptionStates.key === VERBOSE_MODE_OPTION_KEY) {
        chosenOptionStates.verboseMode = listedOptionStates.checked === 'on';
      }
      return chosenOptionStates;
    }, {
      ...displayOptions
    });
    onChange(updateOptionState);
  };
  const popOver = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: OptionButton,
    isOpen: isOptionDropdownOpen,
    closePopover: closeOptionButton
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: optionsList,
    onChange: handleSelect
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: styles.selectable
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Display options",
    id: "xpack.sessionView.sessionViewToggle.sessionViewToggleTitle"
  })), list)));
  return !isOptionDropdownOpen && showVerboseSearchTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    ref: tooltipRef,
    position: "bottom",
    title: VERBOSE_TOOLTIP_TITLE,
    content: VERBOSE_TOOLTIP_CONTENT
  }, popOver) : popOver;
};
exports.SessionViewDisplayOptions = SessionViewDisplayOptions;