"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = (minimal = false, isInvestigated = false) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      colors,
      font,
      size,
      border
    } = euiTheme;
    const dangerBorder = (0, _eui.transparentize)(colors.danger, 0.2);
    const dangerBackground = (0, _eui.transparentize)(colors.danger, 0.08);
    const borderThickness = border.width.thin;
    const mediumPadding = size.m;
    let alertTitleColor = colors.text;
    let borderColor = colors.lightShade;
    if (isInvestigated) {
      alertTitleColor = colors.primaryText;
      borderColor = dangerBorder;
    }
    const alertItem = (0, _react2.css)`
      border: ${borderThickness} solid ${borderColor};
      padding: ${mediumPadding};
      border-radius: ${border.radius.medium};

      margin: 0 ${mediumPadding} ${mediumPadding} ${mediumPadding};
      background-color: ${colors.emptyShade};

      & .euiAccordion__buttonContent {
        width: 100%;
      }

      & .euiAccordion__button {
        min-width: 0;
        width: calc(100% - ${size.l});
      }

      & .euiAccordion__childWrapper {
        overflow: visible;
      }
    `;
    const alertGroupItem = (0, _react2.css)`
      ${alertItem}

      & .euiAccordion__childWrapper {
        overflow: hidden;
      }
    `;
    const alertTitleContainer = {
      display: minimal ? 'none' : 'initial',
      color: alertTitleColor,
      fontWeight: font.weight.semiBold
    };
    const alertTitle = {
      textOverflow: 'ellipsis',
      overflow: 'hidden',
      whiteSpace: 'nowrap'
    };
    const alertIcon = {
      marginRight: size.s
    };
    const alertAccordionButton = {
      width: `calc(100% - ${size.l})`,
      minWidth: 0
    };
    const alertCountArrowPad = {
      marginRight: size.xs
    };
    const processPanel = {
      border: `${borderThickness} solid ${colors.lightShade}`,
      fontFamily: font.familyCode,
      marginTop: minimal ? size.s : size.m,
      padding: `${size.xs} ${size.s}`
    };
    const investigatedLabel = {
      position: 'relative',
      zIndex: 1,
      bottom: `-${mediumPadding}`,
      left: `-${mediumPadding}`,
      width: `calc(100% + ${mediumPadding} * 2)`,
      borderTop: `${borderThickness} solid ${dangerBorder}`,
      borderBottomLeftRadius: border.radius.medium,
      borderBottomRightRadius: border.radius.medium,
      backgroundColor: dangerBackground,
      textAlign: 'center'
    };
    const minimalContextMenu = {
      float: 'right'
    };
    const firstAlertPad = {
      '&:first-child': {
        paddingTop: size.base
      }
    };
    const minimalHR = {
      marginBottom: 0
    };
    return {
      alertItem,
      alertGroupItem,
      alertTitleContainer,
      alertTitle,
      alertIcon,
      alertAccordionButton,
      alertCountArrowPad,
      processPanel,
      investigatedLabel,
      minimalContextMenu,
      firstAlertPad,
      minimalHR
    };
  }, [euiTheme, isInvestigated, minimal]);
  return cached;
};
exports.useStyles = useStyles;