"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSetupEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_connector_types = require("../../hooks/api/use_connector_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSetupEmptyPrompt = ({
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const connectorsIconPath = assetBasePath + '/connectors.svg';
  const connectorPath = http.basePath.prepend(`/app/connectors/${connector.id}`);
  const connectorType = connectorTypes.find(cType => cType.serviceType === connector.service_type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: connectorsIconPath
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.connector.title",
      defaultMessage: "Set up your connector"
    }))),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.connector.body",
      defaultMessage: "This index is managed by an existing connector."
    })), !!connectorType && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      title: connectorType.name,
      id: connectorType.serviceType,
      type: connectorType.iconPath,
      style: {
        marginBottom: '0px'
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, connectorType.name)))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "serverlessSearchConnectorSetupEmptyPromptViewConnectorButton",
      fill: true,
      href: connectorPath
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.connector.action",
      defaultMessage: "View Connector"
    }))
  }));
};
exports.ConnectorSetupEmptyPrompt = ConnectorSetupEmptyPrompt;