"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeDateMath = normalizeDateMath;
var _time_duration = require("../time_duration/time_duration");
var _calc_date_math_diff = require("./calc_date_math_diff");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Normalizes date math
 */
function normalizeDateMath(input) {
  try {
    const ms = (0, _calc_date_math_diff.calcDateMathDiff)('now', input);
    if (ms === undefined || ms > -1000 && ms < 1000) {
      return input;
    }
    if (ms === 0) {
      return 'now';
    }
    const offset = _time_duration.TimeDuration.fromMilliseconds(ms);
    return offset.value < 0 ? `now${offset}` : `now+${offset}`;
  } catch {
    return input;
  }
}