"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Client = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreHttpCommon = require("@kbn/core-http-common");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Lists API client for quickstart
 *   version: Bundle (no version)
 */

class Client {
  constructor(options) {
    (0, _defineProperty2.default)(this, "kbnClient", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.kbnClient = options.kbnClient;
    this.log = options.log;
  }
  /**
   * Create a new list.
   */
  async createList(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateList`);
    return this.kbnClient.request({
      path: '/api/lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Create `.lists` and `.items` data streams in the relevant space.
   */
  async createListIndex() {
    this.log.info(`${new Date().toISOString()} Calling API CreateListIndex`);
    return this.kbnClient.request({
      path: '/api/lists/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Create a list item and associate it with the specified list.
  All list items in the same list must be the same type. For example, each list item in an `ip` list must define a specific IP address.
  > info
  > Before creating a list item, you must create a list.
     */
  async createListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateListItem`);
    return this.kbnClient.request({
      path: '/api/lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Delete a list using the list ID.
  > info
  > When you delete a list, all of its list items are also deleted.
     */
  async deleteList(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteList`);
    return this.kbnClient.request({
      path: '/api/lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete the `.lists` and `.items` data streams.
   */
  async deleteListIndex() {
    this.log.info(`${new Date().toISOString()} Calling API DeleteListIndex`);
    return this.kbnClient.request({
      path: '/api/lists/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete a list item using its `id`, or its `list_id` and `value` fields.
   */
  async deleteListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteListItem`);
    return this.kbnClient.request({
      path: '/api/lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Export list item values from the specified list.
   */
  async exportListItems(props) {
    this.log.info(`${new Date().toISOString()} Calling API ExportListItems`);
    return this.kbnClient.request({
      path: '/api/lists/items/_export',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get all list items in the specified list.
   */
  async findListItems(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindListItems`);
    return this.kbnClient.request({
      path: '/api/lists/items/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a paginated subset of lists. By default, the first page is returned, with 20 results per page.
   */
  async findLists(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindLists`);
    return this.kbnClient.request({
      path: '/api/lists/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Import list items from a TXT or CSV file. The maximum file size is 9 million bytes.
  You can import items to a new or existing list.
     */
  async importListItems(props) {
    this.log.info(`${new Date().toISOString()} Calling API ImportListItems`);
    return this.kbnClient.request({
      path: '/api/lists/items/_import',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.attachment,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Update specific fields of an existing list using the list ID.
   */
  async patchList(props) {
    this.log.info(`${new Date().toISOString()} Calling API PatchList`);
    return this.kbnClient.request({
      path: '/api/lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Update specific fields of an existing list item using the list item ID.
   */
  async patchListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API PatchListItem`);
    return this.kbnClient.request({
      path: '/api/lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of a list using the list ID.
   */
  async readList(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadList`);
    return this.kbnClient.request({
      path: '/api/lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Verify that `.lists` and `.items` data streams exist.
   */
  async readListIndex() {
    this.log.info(`${new Date().toISOString()} Calling API ReadListIndex`);
    return this.kbnClient.request({
      path: '/api/lists/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of a list item.
   */
  async readListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadListItem`);
    return this.kbnClient.request({
      path: '/api/lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async readListPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API ReadListPrivileges`);
    return this.kbnClient.request({
      path: '/api/lists/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Update a list using the list ID. The original list is replaced, and all unspecified fields are deleted.
  > info
  > You cannot modify the `id` value.
     */
  async updateList(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateList`);
    return this.kbnClient.request({
      path: '/api/lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Update a list item using the list item ID. The original list item is replaced, and all unspecified fields are deleted.
  > info
  > You cannot modify the `id` value.
     */
  async updateListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateListItem`);
    return this.kbnClient.request({
      path: '/api/lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
}
exports.Client = Client;