"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Client = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreHttpCommon = require("@kbn/core-http-common");
var _shared = require("@kbn/openapi-common/shared");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Exceptions API client for quickstart
 *   version: Bundle (no version)
 */

class Client {
  constructor(options) {
    (0, _defineProperty2.default)(this, "kbnClient", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.kbnClient = options.kbnClient;
    this.log = options.log;
  }
  /**
    * An exception list groups exception items and can be associated with detection rules. You can assign detection rules with multiple exception lists.
  > info
  > All exception items added to the same list are evaluated using `OR` logic. That is, if any of the items in a list evaluate to `true`, the exception prevents the rule from generating an alert. Likewise, `OR` logic is used for evaluating exceptions when more than one exception list is assigned to a rule. To use the `AND` operator, you can define multiple clauses (`entries`) in a single exception item.
     */
  async createExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Create an exception item and associate it with the specified exception list.
  > info
  > Before creating exception items, you must create an exception list.
     */
  async createExceptionListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateExceptionListItem`);
    return this.kbnClient.request({
      path: '/api/exception_lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Create exception items that apply to a single detection rule.
   */
  async createRuleExceptionListItems(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateRuleExceptionListItems`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/detection_engine/rules/{id}/exceptions', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * An exception list groups exception items and can be associated with detection rules. A shared exception list can apply to multiple detection rules.
  > info
  > All exception items added to the same list are evaluated using `OR` logic. That is, if any of the items in a list evaluate to `true`, the exception prevents the rule from generating an alert. Likewise, `OR` logic is used for evaluating exceptions when more than one exception list is assigned to a rule. To use the `AND` operator, you can define multiple clauses (`entries`) in a single exception item.
     */
  async createSharedExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateSharedExceptionList`);
    return this.kbnClient.request({
      path: '/api/exceptions/shared',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete an exception list using the `id` or `list_id` field.
   */
  async deleteExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete an exception list item using the `id` or `item_id` field.
   */
  async deleteExceptionListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteExceptionListItem`);
    return this.kbnClient.request({
      path: '/api/exception_lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Duplicate an existing exception list.
   */
  async duplicateExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API DuplicateExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists/_duplicate',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Export an exception list and its associated items to an NDJSON file.
   */
  async exportExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API ExportExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists/_export',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a list of all exception list items in the specified list.
   */
  async findExceptionListItems(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindExceptionListItems`);
    return this.kbnClient.request({
      path: '/api/exception_lists/items/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a list of all exception lists.
   */
  async findExceptionLists(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindExceptionLists`);
    return this.kbnClient.request({
      path: '/api/exception_lists/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Import an exception list and its associated items from an NDJSON file.
   */
  async importExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API ImportExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists/_import',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.attachment,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of an exception list using the `id` or `list_id` field.
   */
  async readExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of an exception list item using the `id` or `item_id` field.
   */
  async readExceptionListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadExceptionListItem`);
    return this.kbnClient.request({
      path: '/api/exception_lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a summary of the specified exception list.
   */
  async readExceptionListSummary(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadExceptionListSummary`);
    return this.kbnClient.request({
      path: '/api/exception_lists/summary',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Update an exception list using the `id` or `list_id` field.
   */
  async updateExceptionList(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateExceptionList`);
    return this.kbnClient.request({
      path: '/api/exception_lists',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Update an exception list item using the `id` or `item_id` field.
   */
  async updateExceptionListItem(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateExceptionListItem`);
    return this.kbnClient.request({
      path: '/api/exception_lists/items',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
}
exports.Client = Client;