"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateEndpointListItemResponse = exports.UpdateEndpointListItemRequestBody = void 0;
var _zod = require("@kbn/zod");
var _exception_list_common = require("@kbn/securitysolution-exceptions-common/api/model/exception_list_common.gen");
var _exception_list_item_entry = require("@kbn/securitysolution-exceptions-common/api/model/exception_list_item_entry.gen");
var _endpoint_list_common = require("../model/endpoint_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Update endpoint list item API endpoint
 *   version: 2023-10-31
 */

const UpdateEndpointListItemRequestBody = exports.UpdateEndpointListItemRequestBody = _zod.z.object({
  /**
   * Either `id` or `item_id` must be specified
   */
  id: _exception_list_common.ExceptionListItemId.optional(),
  /**
   * Either `id` or `item_id` must be specified
   */
  item_id: _exception_list_common.ExceptionListItemHumanId.optional(),
  type: _exception_list_common.ExceptionListItemType,
  name: _exception_list_common.ExceptionListItemName,
  description: _exception_list_common.ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray,
  os_types: _exception_list_common.ExceptionListItemOsTypeArray.optional().default([]),
  tags: _exception_list_common.ExceptionListItemTags.optional(),
  meta: _exception_list_common.ExceptionListItemMeta.optional(),
  comments: _exception_list_common.ExceptionListItemCommentArray.optional().default([]),
  _version: _zod.z.string().optional()
});
const UpdateEndpointListItemResponse = exports.UpdateEndpointListItemResponse = _endpoint_list_common.EndpointListItem;