"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesProductFeaturesConfigurator = void 0;
var _config = require("@kbn/security-solution-features/config");
var _constants = require("@kbn/cases-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesProductFeaturesConfigurator = enabledProductFeatureKeys => () => {
  return (0, _config.createEnabledProductFeaturesConfigMap)(casesProductFeaturesConfig, enabledProductFeatureKeys);
};

/**
 * Maps the ProductFeatures keys to Kibana privileges that will be merged
 * into the base privileges config for the Security Cases app.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security Cases feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Cases subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Cases subFeature with the privilege `id` specified.
 */
exports.getCasesProductFeaturesConfigurator = getCasesProductFeaturesConfigurator;
const casesProductFeaturesConfig = {
  ...(0, _config.getCasesDefaultProductFeaturesConfig)({
    apiTags: {
      connectors: _constants.GET_CONNECTORS_CONFIGURE_API_TAG
    },
    uiCapabilities: {
      connectors: _constants.CASES_CONNECTORS_CAPABILITY
    }
  })
  // serverless-specific app features configs here
};