"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serverConfigSchema = exports.createConfig = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _config = require("../common/config");
var _experimental_features = require("../common/experimental_features");
var _metering = require("./endpoint/constants/metering");
var _metering2 = require("./ai4soc/constants/metering");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tlsConfig = _configSchema.schema.object({
  certificate: _configSchema.schema.string(),
  key: _configSchema.schema.string(),
  ca: _configSchema.schema.string()
});
const usageApiConfig = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  url: _configSchema.schema.maybe(_configSchema.schema.string()),
  tls: _configSchema.schema.maybe(tlsConfig)
});
const serverConfigSchema = exports.serverConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  /**
   * Usage Reporting: the interval between runs of the endpoint task
   */

  usageReportingTaskInterval: _configSchema.schema.string({
    defaultValue: _metering.METERING_TASK.INTERVAL
  }),
  /**
   * Usage Reporting: the interval between runs of the cloud security task
   */
  cloudSecurityUsageReportingTaskInterval: _configSchema.schema.string({
    defaultValue: '30m'
  }),
  /**
   * Usage Reporting: the interval between runs of the ai4soc metering task
   */

  ai4SocUsageReportingTaskInterval: _configSchema.schema.string({
    defaultValue: _metering2.METERING_TASK.INTERVAL
  }),
  /**
   * Usage Reporting: timeout value for how long the task should run.
   */
  usageReportingTaskTimeout: _configSchema.schema.string({
    defaultValue: '1m'
  }),
  usageApi: usageApiConfig
});
const configSchema = _configSchema.schema.allOf([_config.commonConfigSchema, serverConfigSchema]);
const config = exports.config = {
  exposeToBrowser: _config.exposeToBrowser,
  schema: configSchema,
  deprecations: ({
    renameFromRoot
  }) => [renameFromRoot('xpack.serverless.security.productTypes', 'xpack.securitySolutionServerless.productTypes', {
    silent: true,
    level: 'warning'
  })]
};
const createConfig = (context, securitySolution) => {
  const {
    enableExperimental,
    ...pluginConfig
  } = context.config.get();
  const logger = context.logger.get('config');
  const {
    invalid,
    duplicated,
    features: experimentalFeatures
  } = (0, _experimental_features.parseExperimentalConfigValue)(enableExperimental, securitySolution.experimentalFeatures);
  if (invalid.length) {
    logger.warn(`Unsupported "xpack.securitySolutionServerless.enableExperimental" values detected.
The following configuration values are not supported and should be removed from the configuration:

    xpack.securitySolutionServerless.enableExperimental:
${invalid.map(key => `      - ${key}`).join('\n')}
`);
  }
  if (duplicated.length) {
    logger.warn(`Duplicated "xpack.securitySolutionServerless.enableExperimental" values detected.
The following configuration values are should only be defined using the generic "xpack.securitySolution.enableExperimental":

    xpack.securitySolutionServerless.enableExperimental:
${duplicated.map(key => `      - ${key}`).join('\n')}
`);
  }
  return {
    ...pluginConfig,
    experimentalFeatures
  };
};
exports.createConfig = createConfig;