"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertObjectKeysToSnakeCase = exports.convertObjectKeysToCamelCase = void 0;
var _camelcaseKeys = _interopRequireDefault(require("camelcase-keys"));
var _snakecaseKeys = _interopRequireDefault(require("snakecase-keys"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertObjectKeysToCamelCase = obj => {
  return (0, _camelcaseKeys.default)(obj, {
    deep: true
  });
};
exports.convertObjectKeysToCamelCase = convertObjectKeysToCamelCase;
const convertObjectKeysToSnakeCase = obj => {
  return (0, _snakecaseKeys.default)(obj, {
    deep: true
  });
};
exports.convertObjectKeysToSnakeCase = convertObjectKeysToSnakeCase;