"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypeUsageSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeUsageSchema = exports.ruleTypeUsageSchema = {
  query: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of query rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of query rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by query rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to query detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled query rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled query rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of query rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of query rules configured with two suppression fields'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of query rules configured with three suppression fields'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of query rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of query rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of query rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of query rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled query rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled query rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within query rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within query rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of query rules with exceptions'
      }
    }
  },
  query_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom query rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom query detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query detection rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query detection rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query detection rules with custom notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom query detection rules with custom notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom query detection rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom query rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom query rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom query rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom query rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom query rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom query rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom query rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom query rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom query rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom query rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom query rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom query rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom query rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom query rules with exceptions'
      }
    }
  },
  threshold: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of threshold rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of threshold rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by threshold rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to threshold detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled threshold rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled threshold rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of threshold rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of threshold rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of threshold rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of threshold rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of threshold rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of threshold rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of threshold rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled threshold rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled threshold rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within threshold rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within threshold rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of threshold rules with exceptions'
      }
    }
  },
  threshold_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom threshold rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom threshold detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom threshold rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom threshold rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom threshold rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom threshold rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom threshold rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom threshold rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom threshold rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom threshold rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom threshold rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom threshold rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom threshold rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom threshold rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom threshold rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom threshold rules with exceptions'
      }
    }
  },
  eql: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of eql rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of eql rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by eql rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to eql detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled eql rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled eql rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of eql rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of eql rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of eql rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of eql rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of eql rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of eql rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of eql rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled eql rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled eql rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within eql rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within eql rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of EQL rules with exceptions'
      }
    }
  },
  eql_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom eql rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom eql rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom eql rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom eql detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom eql rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom eql rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom eql rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom eql rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom eql rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom eql rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom eql rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom eql rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom eql rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom EQL rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom EQL rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom EQL rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom EQL rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom EQL rules with exceptions'
      }
    }
  },
  machine_learning: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of machine_learning rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of machine_learning rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by machine_learning rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to machine_learning detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled machine_learning rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled machine_learning rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of machine_learning rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of machine_learning rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of machine_learning rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of machine_learning rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of machine_learning rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of machine_learning rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of machine_learning rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled ML rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled ML rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within ML rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within ML rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of ML rules with exceptions'
      }
    }
  },
  machine_learning_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom machine_learning rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom machine_learning rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom machine_learning rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom machine_learning detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom machine_learning rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom machine_learning rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom machine_learning rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom machine_learning rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom machine_learning rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom machine_learning rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom machine_learning rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom machine_learning rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom machine_learning rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom ML rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom ML rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom ML rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom ML rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom ML rules with exceptions'
      }
    }
  },
  threat_match: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of threat_match rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of threat_match rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by threat_match rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to threat_match detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled threat_match rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled threat_match rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of threat_match rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of threat_match rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of threat_match rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of threat_match rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of threat_match rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of threat_match rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of threat_match rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled threat match rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled threat match rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within threat match rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within threat match rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of threat match rules with exceptions'
      }
    }
  },
  threat_match_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threat_match rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom threat_match rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom threat_match rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom threat_match detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom IM rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom IM rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom IM rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom IM rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom IM rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom threat_match rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom threat_match rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom threat_match rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom threat_match rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom threat_match rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom threat_match rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom threat_match rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom threat_match rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom threat_match rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom threat match rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom threat match rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom threat match rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom threat match rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom threat match rules with exceptions'
      }
    }
  },
  new_terms: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of new_terms rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of new_terms rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by new_terms rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to new_terms detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled new_terms rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled new_terms rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of new_terms rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of new_terms rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of new_terms rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of new_terms rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of new_terms rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of new_terms rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of new_terms rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled new terms rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled new terms rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within new terms rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within new terms rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of New Terms rules with exceptions'
      }
    }
  },
  new_terms_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom new_terms rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom new_terms rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom new_terms rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom new_terms detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom new_terms rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom new_terms rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom new_terms rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom new_terms rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom new_terms rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom new_terms rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom new_terms rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom new_terms rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom new_terms rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom new terms rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom new terms rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom new terms rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom new terms rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom New Terms rules with exceptions'
      }
    }
  },
  esql: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of esql rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of esql rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by esql rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to esql detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled esql rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled esql rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of esql rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of esql rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of esql rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of esql rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of esql rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of esql rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of esql rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled ES|QL rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled ES|QL rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within ES|QL rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within ES|QL rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of ES|QL rules with exceptions'
      }
    }
  },
  esql_custom: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom esql rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom esql rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom esql rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom esql detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules with legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules with legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules with notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules with notifications disabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom esql rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom esql rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom esql rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom esql rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom esql rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom esql rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom esql rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom esql rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom esql rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom ES|QL rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom ES|QL rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom ES|QL rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom ES|QL rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom ES|QL rules with exceptions'
      }
    }
  },
  elastic_total: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of elastic rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of elastic rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by elastic rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to elastic detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled elastic rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled elastic rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of elastic rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of elastic rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of elastic rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of elastic rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of elastic rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of elastic rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of elastic rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled elastic rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled elastic rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within elastic rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within elastic rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of elastic rules with exceptions'
      }
    }
  },
  elastic_customized_total: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of customized elastic rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of customized elastic rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by customized elastic rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to customized elastic detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled customized elastic rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled customized elastic rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of customized elastic rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of customized elastic rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of customized elastic rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of customized elastic rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of customized elastic rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of customized elastic rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of customized elastic rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled customized elastic rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled customized elastic rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within customized elastic rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within customized elastic rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of customized elastic rules with exceptions'
      }
    }
  },
  elastic_noncustomized_total: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of non-customized elastic rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of non-customized elastic rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by non-customized elastic rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to non-customized elastic detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled non-customized elastic rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled non-customized elastic rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of non-customized elastic rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of non-customized elastic rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of non-customized elastic rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of non-customized elastic rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of non-customized elastic rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of non-customized elastic rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of non-customized elastic rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled non-customized elastic rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled non-customized elastic rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within non-customized elastic rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within non-customized elastic rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of non-customized elastic rules with exceptions'
      }
    }
  },
  custom_total: {
    enabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom rules enabled'
      }
    },
    disabled: {
      type: 'long',
      _meta: {
        description: 'Number of custom rules disabled'
      }
    },
    alerts: {
      type: 'long',
      _meta: {
        description: 'Number of alerts generated by custom rules'
      }
    },
    cases: {
      type: 'long',
      _meta: {
        description: 'Number of cases attached to custom detection rule alerts'
      }
    },
    legacy_notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications enabled'
      }
    },
    legacy_notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of legacy notifications disabled'
      }
    },
    notifications_enabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    notifications_disabled: {
      type: 'long',
      _meta: {
        description: 'Number of notifications enabled'
      }
    },
    legacy_investigation_fields: {
      type: 'long',
      _meta: {
        description: 'Number of rules using the legacy investigation fields type introduced only in 8.10 ESS'
      }
    },
    alert_suppression: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom rules configured with suppression'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom rules configured with suppression'
        }
      },
      suppressed_fields_count: {
        one: {
          type: 'long',
          _meta: {
            description: 'Number of custom rules configured with one suppression field'
          }
        },
        two: {
          type: 'long',
          _meta: {
            description: 'Number of custom rules configured with two suppression field'
          }
        },
        three: {
          type: 'long',
          _meta: {
            description: 'Number of custom rules configured with three suppression field'
          }
        }
      },
      suppressed_per_time_period: {
        type: 'long',
        _meta: {
          description: 'Number of custom rules configured with suppression per time period'
        }
      },
      suppressed_per_rule_execution: {
        type: 'long',
        _meta: {
          description: 'Number of custom rules configured with suppression per rule execution'
        }
      },
      suppresses_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom rules configured to suppress alerts with missing fields'
        }
      },
      does_not_suppress_missing_fields: {
        type: 'long',
        _meta: {
          description: 'Number of custom rules configured do not suppress alerts with missing fields'
        }
      }
    },
    response_actions: {
      enabled: {
        type: 'long',
        _meta: {
          description: 'Number of enabled custom rules configured with response actions'
        }
      },
      disabled: {
        type: 'long',
        _meta: {
          description: 'Number of disabled custom rules configured with response actions'
        }
      },
      response_actions: {
        endpoint: {
          type: 'long',
          _meta: {
            description: 'Number of endpoint response actions within custom rules'
          }
        },
        osquery: {
          type: 'long',
          _meta: {
            description: 'Number of osquery response actions within custom rules'
          }
        }
      }
    },
    has_exceptions: {
      type: 'long',
      _meta: {
        description: 'Number of custom rules with exceptions'
      }
    }
  }
};