"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHttpEdges = void 0;
var _fp = require("lodash/fp");
var _ecs_safety_helpers = require("../../../../../../common/endpoint/models/ecs_safety_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHttpEdges = response => formatHttpEdges((0, _fp.getOr)([], `aggregations.url.buckets`, response.rawResponse));
exports.getHttpEdges = getHttpEdges;
const formatHttpEdges = buckets => buckets.map(bucket => {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const getKey = ({
    key
  }) => (0, _ecs_safety_helpers.firstNonNullValue)(key);
  const bucketKey = (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key);
  return {
    node: {
      _id: bucketKey,
      domains: bucket.domains.buckets.map(getKey),
      methods: bucket.methods.buckets.map(getKey),
      statuses: bucket.status.buckets.map(getKey),
      lastHost: (0, _fp.get)('source.hits.hits[0].fields["host.name"]', bucket),
      lastSourceIp: (0, _fp.get)('source.hits.hits[0].fields["source.ip"]', bucket),
      path: bucketKey,
      requestCount: bucket.doc_count
    },
    cursor: {
      value: bucketKey,
      tiebreaker: null
    }
  };
});