"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securitySolutionFactory = void 0;
var _hosts = require("./hosts");
var _network = require("./network");
var _cti = require("./cti");
var _risk_score = require("./risk_score");
var _users = require("./users");
var _last_first_seen = require("./last_first_seen");
var _related_entities = require("./related_entities");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const securitySolutionFactory = exports.securitySolutionFactory = {
  ..._hosts.hostsFactory,
  ..._users.usersFactory,
  ..._services.servicesFactory,
  ..._network.networkFactory,
  ..._cti.ctiFactoryTypes,
  ..._risk_score.riskScoreFactory,
  ..._last_first_seen.firstLastSeenFactory,
  ..._related_entities.relatedEntitiesFactory
};