"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistFavoriteRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../detection_engine/routes/utils");
var _common = require("../../../utils/common");
var _timelines = require("../../../saved_object/timelines");
var _timeline = require("../../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistFavoriteRoute = router => {
  router.versioned.patch({
    path: _constants.TIMELINE_FAVORITE_URL,
    security: {
      authz: {
        requiredPrivileges: ['timeline_write']
      }
    },
    access: 'public'
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.PersistFavoriteRouteRequestBody)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      const {
        timelineId,
        templateTimelineId,
        templateTimelineVersion,
        timelineType
      } = request.body;
      const timeline = await (0, _timelines.persistFavorite)(frameworkRequest, timelineId || null, templateTimelineId || null, templateTimelineVersion || null, timelineType || _timeline.TimelineTypeEnum.default);
      const body = {
        data: {
          persistFavorite: timeline
        }
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.persistFavoriteRoute = persistFavoriteRoute;