"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryCounter = exports.TelemetryChannel = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// For getting cluster info. Copied from telemetry_collection/get_cluster_info.ts
// From https://www.elastic.co/guide/en/elasticsearch/reference/current/get-license.html
// Telemetry
/**
 * List of supported telemetry channels.
 */
let TelemetryChannel = exports.TelemetryChannel = /*#__PURE__*/function (TelemetryChannel) {
  TelemetryChannel["LISTS"] = "security-lists-v2";
  TelemetryChannel["ENDPOINT_META"] = "endpoint-metadata";
  TelemetryChannel["ENDPOINT_ALERTS"] = "alerts-endpoint";
  TelemetryChannel["DETECTION_ALERTS"] = "alerts-detections";
  TelemetryChannel["TIMELINE"] = "alerts-timeline";
  TelemetryChannel["INSIGHTS"] = "security-insights-v1";
  TelemetryChannel["TASK_METRICS"] = "task-metrics";
  return TelemetryChannel;
}({});
let TelemetryCounter = exports.TelemetryCounter = /*#__PURE__*/function (TelemetryCounter) {
  TelemetryCounter["DOCS_SENT"] = "docs_sent";
  TelemetryCounter["DOCS_LOST"] = "docs_lost";
  TelemetryCounter["DOCS_DROPPED"] = "docs_dropped";
  TelemetryCounter["HTTP_STATUS"] = "http_status";
  TelemetryCounter["RUNTIME_ERROR"] = "runtime_error";
  TelemetryCounter["FATAL_ERROR"] = "fatal_error";
  TelemetryCounter["TELEMETRY_OPTED_OUT"] = "telemetry_opted_out";
  TelemetryCounter["TELEMETRY_NOT_REACHABLE"] = "telemetry_not_reachable";
  TelemetryCounter["NUM_ENDPOINT"] = "num_endpoint";
  return TelemetryCounter;
}({}); // EP Policy Response
// EP Metrics
// EP Metadata
// Telemetry List types
// Detection Rule types
// EP Timeline telemetry