"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLoopUtilizationCircuitBreaker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _perf_hooks = require("perf_hooks");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Configuration interface for Event Loop Utilization Circuit Breaker.
 */

class EventLoopUtilizationCircuitBreaker extends _utils.BaseCircuitBreaker {
  constructor(config) {
    super();
    (0, _defineProperty2.default)(this, "startUtilization", void 0);
    this.config = config;
    this.startUtilization = _perf_hooks.performance.eventLoopUtilization();
  }
  async validate() {
    const eventLoop = _perf_hooks.performance.eventLoopUtilization(this.startUtilization);
    const exceeded = eventLoop.active > this.config.thresholdMillis;
    if (exceeded) {
      return this.failure(`Event loop utilization exceeded: ${eventLoop.active.toString()}`);
    }
    return this.success();
  }
  stats() {
    return {
      startUtilization: this.startUtilization
    };
  }
  validationIntervalMs() {
    return this.config.validationIntervalMs;
  }
}
exports.EventLoopUtilizationCircuitBreaker = EventLoopUtilizationCircuitBreaker;