"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _integration_retriever = require("./integration_retriever");
var _prebuilt_rules_retriever = require("./prebuilt_rules_retriever");
var _rule_resource_retriever = require("./rule_resource_retriever");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The timeout to populate ELSER indices in minutes */
const POPULATE_ELSER_INDICES_TIMEOUT_MIN = 20;

/**
 * RuleMigrationsRetriever is a class that is responsible for retrieving all the necessary data during the rule migration process.
 * It is composed of multiple retrievers that are responsible for retrieving specific types of data.
 * Such as rule integrations, prebuilt rules, and rule resources.
 */
class RuleMigrationsRetriever {
  constructor(migrationId, clients) {
    (0, _defineProperty2.default)(this, "resources", void 0);
    (0, _defineProperty2.default)(this, "integrations", void 0);
    (0, _defineProperty2.default)(this, "prebuiltRules", void 0);
    this.resources = new _rule_resource_retriever.RuleResourceRetriever(migrationId, clients.data);
    this.integrations = new _integration_retriever.IntegrationRetriever(clients);
    this.prebuiltRules = new _prebuilt_rules_retriever.PrebuiltRulesRetriever(clients);
  }
  async populateElserIndices() {
    try {
      await Promise.race([Promise.all([this.prebuiltRules.populateIndex(), this.integrations.populateIndex()]), new Promise((_, reject) => {
        setTimeout(() => reject(new Error(`Timeout (${POPULATE_ELSER_INDICES_TIMEOUT_MIN}m)`)), POPULATE_ELSER_INDICES_TIMEOUT_MIN * 60 * 1000);
      })]);
    } catch (err) {
      throw new Error(`Failed to populate ELSER indices. Make sure the ELSER model is deployed and running at Machine Learning > Trained Models. ${err}`);
    }
  }
  async initialize() {
    // Run only one populateIndices promise at a time, if one is already running, wait for it to finish
    if (RuleMigrationsRetriever.populatePromise === null) {
      RuleMigrationsRetriever.populatePromise = this.populateElserIndices().finally(() => {
        RuleMigrationsRetriever.populatePromise = null;
      });
    }
    await Promise.all([RuleMigrationsRetriever.populatePromise, this.resources.initialize()]);
  }
}
exports.RuleMigrationsRetriever = RuleMigrationsRetriever;
(0, _defineProperty2.default)(RuleMigrationsRetriever, "populatePromise", null);