"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationIndexMigrator = void 0;
var _rule_migrations_per_space_index_migrator = require("./rule_migrations_per_space_index_migrator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationIndexMigrator {
  constructor(ruleMigrationIndexAdapters, esClient, logger) {
    this.ruleMigrationIndexAdapters = ruleMigrationIndexAdapters;
    this.esClient = esClient;
    this.logger = logger;
  }
  async getSpaceListForMigrations() {
    const rulesIndicesAcrossSpaces = await this.esClient.indices.get({
      index: this.ruleMigrationIndexAdapters.rules.getIndexName('*'),
      allow_no_indices: true
    });
    const rulesIndexPatternPrefix = this.ruleMigrationIndexAdapters.rules.getIndexName('');
    const spaceList = Object.keys(rulesIndicesAcrossSpaces).map(index => {
      return index.replace(rulesIndexPatternPrefix, '');
    });
    return spaceList;
  }
  async run() {
    const allSpaces = await this.getSpaceListForMigrations();
    if (allSpaces.length === 0) {
      this.logger.debug('No spaces or index found for index migration');
      return;
    }
    this.logger.debug(`Starting index migration for rule migrations for spaces :${allSpaces.join(', ')}`);
    for (const spaceId of allSpaces) {
      const migrator = new _rule_migrations_per_space_index_migrator.RuleMigrationSpaceIndexMigrator(spaceId, this.esClient, this.logger, this.ruleMigrationIndexAdapters);
      await migrator.run();
    }
    this.logger.debug('Finished index migration for rule migrations successfully');
  }
}
exports.RuleMigrationIndexMigrator = RuleMigrationIndexMigrator;