"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withExistingMigration = exports.MIGRATION_ID_NOT_FOUND = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIGRATION_ID_NOT_FOUND = id => _i18n.i18n.translate('xpack.securitySolution.api.migrationIdNotFound', {
  defaultMessage: `No Migration found with id: {id}`,
  values: {
    id
  }
});

/**
 * Checks the existence of a valid migration before proceeding with the request.
 *
 * if not found, it returns a 404 error with a message.
 * if found, it adds the migration to the context.
 *
 * */
exports.MIGRATION_ID_NOT_FOUND = MIGRATION_ID_NOT_FOUND;
const withExistingMigration = handler => {
  return async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const ctx = await context.resolve(['securitySolution']);
    const ruleMigrationsClient = ctx.securitySolution.getSiemRuleMigrationsClient();
    const storedMigration = await ruleMigrationsClient.data.migrations.get({
      id: migrationId
    });
    if (!storedMigration) {
      return res.notFound({
        body: MIGRATION_ID_NOT_FOUND(migrationId)
      });
    }
    return handler(context, req, res);
  };
};
exports.withExistingMigration = withExistingMigration;