"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToInternalUpdateRuleMigrationData = exports.isValidEsqlQuery = exports.convertEsqlQueryToTranslationResult = void 0;
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _rule_migration = require("../../../../../../common/siem_migrations/model/rule_migration.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidEsqlQuery = esqlQuery => {
  const {
    isEsqlQueryAggregating,
    hasMetadataOperator,
    errors
  } = (0, _securitysolutionUtils.parseEsqlQuery)(esqlQuery);

  // Check if there are any syntax errors
  if (errors.length) {
    return false;
  }

  // non-aggregating query which does not have metadata, is not a valid one
  if (!isEsqlQueryAggregating && !hasMetadataOperator) {
    return false;
  }
  return true;
};
exports.isValidEsqlQuery = isValidEsqlQuery;
const convertEsqlQueryToTranslationResult = esqlQuery => {
  if (esqlQuery === '') {
    return _rule_migration.RuleMigrationTranslationResultEnum.untranslatable;
  }
  return isValidEsqlQuery(esqlQuery) ? _rule_migration.RuleMigrationTranslationResultEnum.full : _rule_migration.RuleMigrationTranslationResultEnum.partial;
};
exports.convertEsqlQueryToTranslationResult = convertEsqlQueryToTranslationResult;
const transformToInternalUpdateRuleMigrationData = ruleMigration => {
  var _ruleMigration$elasti;
  if (((_ruleMigration$elasti = ruleMigration.elastic_rule) === null || _ruleMigration$elasti === void 0 ? void 0 : _ruleMigration$elasti.query) == null) {
    return ruleMigration;
  }
  return {
    ...ruleMigration,
    translation_result: convertEsqlQueryToTranslationResult(ruleMigration.elastic_rule.query)
  };
};
exports.transformToInternalUpdateRuleMigrationData = transformToInternalUpdateRuleMigrationData;