"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsStatsAllRoute = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("./util/authz");
var _with_license = require("./util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsStatsAllRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATIONS_ALL_STATS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.getSiemRuleMigrationsClient();
      const allStats = await ruleMigrationsClient.task.getAllStats();
      return res.ok({
        body: allStats
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsStatsAllRoute = registerSiemRuleMigrationsStatsAllRoute;