"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsIntegrationsStatsRoute = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("./util/authz");
var _with_license = require("./util/with_license");
var _audit = require("./util/audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsIntegrationsStatsRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATIONS_INTEGRATIONS_STATS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, (0, _with_license.withLicense)(async (context, _req, res) => {
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution);
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.getSiemRuleMigrationsClient();
      await siemMigrationAuditLogger.logGetAllIntegrationsStats();
      const allIntegrationsStats = await ruleMigrationsClient.data.rules.getAllIntegrationsStats();
      return res.ok({
        body: allIntegrationsStats
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logGetAllIntegrationsStats({
        error
      });
      return res.customError({
        statusCode: 500,
        body: error.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsIntegrationsStatsRoute = registerSiemRuleMigrationsIntegrationsStatsRoute;