"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityAnalyticsRunMigrationsRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _repoInfo = require("@kbn/repo-info");
var _constants = require("../../../../../common/constants");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityAnalyticsRunMigrationsRoute = (router, logger, getStartServices) => {
  router.versioned.post({
    access: 'internal',
    path: _constants.ENTITY_ANALYTICS_INTERNAL_RUN_MIGRATIONS_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {}
  }, async (context, request, response) => {
    const securitySolution = await context.securitySolution;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _.scheduleEntityAnalyticsMigration)({
        /*
         * We cannot provide task manager here because the migrations require
         * the setup contract and we can only access the start contract.
         *
         * The setup contarct is used to register kibana tasks.
         *
         * This means the ECS migration will not be run by calling this endpoint.
         *
         * We could modify scheduleEntityAnalyticsMigration to optionally take
         * the start contract and have scheduleEntityAnalyticsMigration call scheduleNow
         * if we wanted to test this migration in the future.
         */
        taskManager: undefined,
        logger,
        getStartServices,
        auditLogger: securitySolution.getAuditLogger(),
        kibanaVersion: _repoInfo.kibanaPackageJson.version
      });
      const body = {
        success: true
      };
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.entityAnalyticsRunMigrationsRoute = entityAnalyticsRunMigrationsRoute;