"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventValue = void 0;
exports.getEventsMapByFieldValue = getEventsMapByFieldValue;
exports.getFieldValue = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEventValue = (event, path) => {
  var _event$_source;
  const value = (0, _lodash.get)(event, `_source.${path}`) || (event === null || event === void 0 ? void 0 : (_event$_source = event._source) === null || _event$_source === void 0 ? void 0 : _event$_source[path]);
  if (Array.isArray(value)) {
    return value[0];
  }
  return value;
};
exports.getEventValue = getEventValue;
const getFieldValue = (event, path) => {
  var _get;
  return (_get = (0, _lodash.get)(event === null || event === void 0 ? void 0 : event.fields, path)) === null || _get === void 0 ? void 0 : _get[0];
};

/** Given an eventField, returns a map of values found in that field to the events that contain that value. */
exports.getFieldValue = getFieldValue;
function getEventsMapByFieldValue(events, eventField) {
  const eventsWithField = events.filter(event => getEventValue(event, eventField));
  const eventsMapByFieldValue = eventsWithField.reduce((acc, event) => {
    const eventFieldValue = getEventValue(event, eventField);
    if (!eventFieldValue) return {};
    acc[eventFieldValue] ??= [];
    acc[eventFieldValue].push(event);
    return acc;
  }, {});
  return eventsMapByFieldValue;
}