"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServiceRiskEnrichments = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _field_names = require("../../../../../../../common/field_maps/field_names");
var _common = require("../../../../../../../common/search_strategy/security_solution/risk_score/common");
var _all = require("../../../../../../../common/search_strategy/security_solution/risk_score/all");
var _create_single_field_match_enrichment = require("../create_single_field_match_enrichment");
var _events = require("../utils/events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createServiceRiskEnrichments = async ({
  services,
  logger,
  events,
  spaceId
}) => {
  return (0, _create_single_field_match_enrichment.createSingleFieldMatchEnrichment)({
    name: 'Service Risk',
    index: [(0, _common.getRiskIndex)(spaceId, true)],
    services,
    logger,
    events,
    mappingField: {
      eventField: 'service.name',
      enrichmentField: _all.RiskScoreFields.serviceName
    },
    enrichmentResponseFields: [_all.RiskScoreFields.serviceName, _all.RiskScoreFields.serviceRisk, _all.RiskScoreFields.serviceRiskScore],
    createEnrichmentFunction: enrichment => event => {
      const riskLevel = (0, _events.getFieldValue)(enrichment, _all.RiskScoreFields.serviceRisk);
      const riskScore = (0, _events.getFieldValue)(enrichment, _all.RiskScoreFields.serviceRiskScore);
      if (!riskLevel && !riskScore) {
        return event;
      }
      const newEvent = (0, _lodash.cloneDeep)(event);
      if (riskLevel) {
        (0, _saferLodashSet.set)(newEvent, `_source.${_field_names.ALERT_SERVICE_RISK_SCORE_CALCULATED_LEVEL}`, riskLevel);
      }
      if (riskScore) {
        (0, _saferLodashSet.set)(newEvent, `_source.${_field_names.ALERT_SERVICE_RISK_SCORE_CALCULATED_SCORE_NORM}`, riskScore);
      }
      return newEvent;
    }
  });
};
exports.createServiceRiskEnrichments = createServiceRiskEnrichments;