"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateExcludedDocuments = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Updates the list of excluded documents
 * The last document ID in the multiple results is not excluded to avoid missing alerts in case of mv_expand usage or reaching max_signals limit
 * It is to ensure that in the next page we will be able to catch the rest of expanded values or alerts not created when reached max_signals limit
 */
const updateExcludedDocuments = ({
  excludedDocuments,
  sourceDocuments,
  results,
  isRuleAggregating,
  aggregatableTimestampField
}) => {
  var _results$at;
  // aggregating queries do not have event _id, so we will not exclude any documents
  if (isRuleAggregating) {
    return;
  }
  const documentIds = Object.keys(sourceDocuments);
  const lastId = (_results$at = results.at(-1)) === null || _results$at === void 0 ? void 0 : _results$at._id;
  addToExcludedDocuments(excludedDocuments, sourceDocuments, documentIds.length === 1 ? documentIds : documentIds.filter(id => id !== lastId), aggregatableTimestampField);
};
exports.updateExcludedDocuments = updateExcludedDocuments;
const addToExcludedDocuments = (excludedDocuments, sourceDocuments, documentIds, aggregatableTimestampField) => {
  for (const documentId of documentIds) {
    var _document$fields, _document$fields$aggr;
    const document = sourceDocuments[documentId];
    excludedDocuments.push({
      id: documentId,
      timestamp: (_document$fields = document.fields) === null || _document$fields === void 0 ? void 0 : (_document$fields$aggr = _document$fields[aggregatableTimestampField]) === null || _document$fields$aggr === void 0 ? void 0 : _document$fields$aggr[0]
    });
  }
};