"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleExecutionLogClientForRoutes = void 0;
var _with_security_span = require("../../../../../../utils/with_security_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleExecutionLogClientForRoutes = (eventLog, logger) => {
  return {
    getExecutionEvents: args => {
      return (0, _with_security_span.withSecuritySpan)('IRuleExecutionLogForRoutes.getExecutionEvents', async () => {
        const {
          ruleId
        } = args;
        try {
          return await eventLog.getExecutionEvents(args);
        } catch (e) {
          const logMessage = 'Error getting plain execution events from event log';
          const logReason = e instanceof Error ? e.message : String(e);
          const logSuffix = `[rule id ${ruleId}]`;
          const logMeta = {
            rule: {
              id: ruleId
            }
          };
          logger.error(`${logMessage}: ${logReason} ${logSuffix}`, logMeta);
          throw e;
        }
      });
    },
    getExecutionResults: args => {
      return (0, _with_security_span.withSecuritySpan)('IRuleExecutionLogForRoutes.getExecutionResults', async () => {
        const {
          ruleId
        } = args;
        try {
          return await eventLog.getExecutionResults(args);
        } catch (e) {
          const logMessage = 'Error getting aggregate execution results from event log';
          const logReason = e instanceof Error ? e.message : String(e);
          const logSuffix = `[rule id ${ruleId}]`;
          const logMeta = {
            rule: {
              id: ruleId
            }
          };
          logger.error(`${logMessage}: ${logReason} ${logSuffix}`, logMeta);
          throw e;
        }
      });
    }
  };
};
exports.createRuleExecutionLogClientForRoutes = createRuleExecutionLogClientForRoutes;