"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateRuleSource = calculateRuleSource;
var _calculate_is_customized = require("./calculate_is_customized");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function calculateRuleSource({
  prebuiltRuleAssetClient,
  nextRule,
  currentRule
}) {
  if (nextRule.immutable) {
    // This is a prebuilt rule and, despite the name, they are not immutable. So
    // we need to recalculate `ruleSource.isCustomized` based on the rule's contents.
    const prebuiltRulesResponse = await prebuiltRuleAssetClient.fetchAssetsByVersion([{
      rule_id: nextRule.rule_id,
      version: nextRule.version
    }]);
    const baseRule = prebuiltRulesResponse.at(0);
    const isCustomized = (0, _calculate_is_customized.calculateIsCustomized)({
      baseRule,
      nextRule,
      currentRule
    });
    return {
      type: 'external',
      is_customized: isCustomized
    };
  }
  return {
    type: 'internal'
  };
}