"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertAlertingRuleToRuleResponse = convertAlertingRuleToRuleResponse;
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_schema = require("../../../../../../../common/api/detection_engine/model/rule_schema");
var _internal_rule_to_api_response = require("./internal_rule_to_api_response");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertAlertingRuleToRuleResponse(rule) {
  const parseResult = _rule_schema.RuleResponse.safeParse((0, _internal_rule_to_api_response.internalRuleToAPIResponse)(rule));
  if (!parseResult.success) {
    throw new _utils.RuleResponseValidationError({
      message: (0, _zodHelpers.stringifyZodError)(parseResult.error),
      ruleId: rule.params.ruleId
    });
  }
  return parseResult.data;
}