"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAlertSuppressionBulkEditSupport = void 0;
var _constants = require("../../../../../../common/detection_engine/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkAlertSuppressionBulkEditSupport = async ({
  editActions,
  experimentalFeatures,
  licensing
}) => {
  const hasAlertSuppressionActions = (0, _utils.hasAlertSuppressionBulkEditAction)(editActions);
  const isAlertSuppressionEnabled = experimentalFeatures.bulkEditAlertSuppressionEnabled;
  if (hasAlertSuppressionActions) {
    if (!isAlertSuppressionEnabled) {
      return {
        body: `Bulk alert suppression actions are not supported. Use "experimentalFeatures.bulkEditAlertSuppressionEnabled" config field to enable it.`,
        statusCode: 400
      };
    }
    const isAlertSuppressionLicenseValid = await licensing.license.hasAtLeast(_constants.MINIMUM_LICENSE_FOR_SUPPRESSION);
    if (!isAlertSuppressionLicenseValid) {
      return {
        body: `Alert suppression is enabled with ${_constants.MINIMUM_LICENSE_FOR_SUPPRESSION} license or above.`,
        statusCode: 403
      };
    }
  }
  return undefined;
};
exports.checkAlertSuppressionBulkEditSupport = checkAlertSuppressionBulkEditSupport;