"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEditActionToRulesClientOperation = void 0;
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _utility_types = require("../../../../../../common/utility_types");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * converts bulk edit action to format of rulesClient.bulkEdit operation
 * @param action BulkActionEditForRuleAttributes
 * @returns rulesClient BulkEditOperation
 */
const bulkEditActionToRulesClientOperation = (actionsClient, action) => {
  switch (action.type) {
    // tags actions
    case _rule_management.BulkActionEditTypeEnum.add_tags:
      return [{
        field: 'tags',
        operation: 'add',
        value: action.value
      }];
    case _rule_management.BulkActionEditTypeEnum.delete_tags:
      return [{
        field: 'tags',
        operation: 'delete',
        value: action.value
      }];
    case _rule_management.BulkActionEditTypeEnum.set_tags:
      return [{
        field: 'tags',
        operation: 'set',
        value: action.value
      }];

    // rule actions
    case _rule_management.BulkActionEditTypeEnum.add_rule_actions:
      return [{
        field: 'actions',
        operation: 'add',
        value: (0, _utils.parseAndTransformRuleActions)(actionsClient, action.value.actions, action.value.throttle)
      }];
    case _rule_management.BulkActionEditTypeEnum.set_rule_actions:
      return [{
        field: 'actions',
        operation: 'set',
        value: (0, _utils.parseAndTransformRuleActions)(actionsClient, action.value.actions, action.value.throttle)
      }];

    // schedule actions
    case _rule_management.BulkActionEditTypeEnum.set_schedule:
      return [{
        field: 'schedule',
        operation: 'set',
        value: {
          interval: action.value.interval
        }
      }];
    default:
      return (0, _utility_types.assertUnreachable)(action);
  }
};
exports.bulkEditActionToRulesClientOperation = bulkEditActionToRulesClientOperation;