"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readTags = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _enrich_filter_with_rule_type_mappings = require("../../../logic/search/enrich_filter_with_rule_type_mappings");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readTags = async ({
  rulesClient
}) => {
  const res = await rulesClient.aggregate({
    options: {
      filter: (0, _enrich_filter_with_rule_type_mappings.enrichFilterWithRuleTypeMapping)(undefined)
    },
    aggs: (0, _common.getRuleTagsAggregation)({
      // This is the max limit on the number of tags. In fact it can exceed this number and will be truncated to the hardcoded number.
      maxTags: _constants.EXPECTED_MAX_TAGS
    })
  });
  return (0, _common.formatRuleTagsAggregationResult)(res).ruleTags;
};
exports.readTags = readTags;