"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readRuleRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _constants = require("../../../../../../../common/constants");
var _utils = require("../../../../routes/utils");
var _read_rules = require("../../../logic/detection_rules_client/read_rules");
var _utils2 = require("../../../utils/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readRuleRoute = (router, logger) => {
  router.versioned.get({
    access: 'public',
    path: _constants.DETECTION_ENGINE_RULES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_management.ReadRuleRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const validationErrors = (0, _rule_management.validateQueryRuleByIds)(request.query);
    if (validationErrors.length) {
      return siemResponse.error({
        statusCode: 400,
        body: validationErrors
      });
    }
    const {
      id,
      rule_id: ruleId
    } = request.query;
    try {
      const rulesClient = await (await context.alerting).getRulesClient();

      // TODO: https://github.com/elastic/kibana/issues/125642 Reuse fetchRuleById
      const rule = await (0, _read_rules.readRules)({
        id,
        rulesClient,
        ruleId
      });
      if (rule != null) {
        const transformed = (0, _utils2.transform)(rule);
        if (transformed == null) {
          return siemResponse.error({
            statusCode: 500,
            body: 'Internal error transforming'
          });
        } else {
          return response.ok({
            body: transformed !== null && transformed !== void 0 ? transformed : {}
          });
        }
      } else {
        const error = (0, _utils2.getIdError)({
          id,
          ruleId
        });
        return siemResponse.error({
          body: error.message,
          statusCode: error.statusCode
        });
      }
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readRuleRoute = readRuleRoute;