"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrebuiltRules = void 0;
var _constants = require("../../../../../../common/constants");
var _promise_pool = require("../../../../../utils/promise_pool");
var _with_security_span = require("../../../../../utils/with_security_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrebuiltRules = (detectionRulesClient, rules, logger) => {
  return (0, _with_security_span.withSecuritySpan)('createPrebuiltRules', async () => {
    logger === null || logger === void 0 ? void 0 : logger.debug(`createPrebuiltRules: Creating prebuilt rules - started. Rules to create: ${rules.length}`);
    const result = await (0, _promise_pool.initPromisePool)({
      concurrency: _constants.MAX_RULES_TO_UPDATE_IN_PARALLEL,
      items: rules,
      executor: async rule => {
        return detectionRulesClient.createPrebuiltRule({
          params: rule
        });
      }
    });
    logger === null || logger === void 0 ? void 0 : logger.debug(`createPrebuiltRules: Creating prebuilt rules - done. Rules created: ${result.results}. Rules failed to create: ${result.errors.length}.`);
    return result;
  });
};
exports.createPrebuiltRules = createPrebuiltRules;