"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prebuiltRuleAssetType = exports.PREBUILT_RULE_ASSETS_SO_TYPE = void 0;
var _configSchema = require("@kbn/config-schema");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREBUILT_RULE_ASSETS_SO_TYPE = exports.PREBUILT_RULE_ASSETS_SO_TYPE = 'security-rule';
const securityRuleV1 = _configSchema.schema.object({
  rule_id: _configSchema.schema.string(),
  version: _configSchema.schema.number()
}, {
  unknowns: 'allow'
});
const securityRuleV2 = securityRuleV1.extends({
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  severity: _configSchema.schema.string(),
  risk_score: _configSchema.schema.number()
}, {
  unknowns: 'allow'
});
const prebuiltRuleAssetMappings = {
  dynamic: false,
  properties: {
    rule_id: {
      type: 'keyword'
    },
    version: {
      type: 'long'
    },
    name: {
      type: 'text',
      fields: {
        keyword: {
          type: 'keyword',
          normalizer: 'lowercase'
        }
      }
    },
    tags: {
      type: 'keyword'
    },
    severity: {
      type: 'keyword'
    },
    risk_score: {
      type: 'float'
    }
  }
};
const prebuiltRuleAssetType = exports.prebuiltRuleAssetType = {
  name: PREBUILT_RULE_ASSETS_SO_TYPE,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  management: {
    importableAndExportable: true,
    visibleInManagement: false
  },
  namespaceType: 'agnostic',
  mappings: prebuiltRuleAssetMappings,
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        forwardCompatibility: securityRuleV1,
        create: securityRuleV1
      }
    },
    '2': {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          name: {
            type: 'text',
            fields: {
              keyword: {
                type: 'keyword',
                normalizer: 'lowercase'
              }
            }
          },
          tags: {
            type: 'keyword'
          },
          severity: {
            type: 'keyword'
          },
          risk_score: {
            type: 'float'
          }
        }
      }],
      schemas: {
        forwardCompatibility: securityRuleV2,
        create: securityRuleV2
      }
    }
  }
};