"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_ASSET_ATTRIBUTES = void 0;
exports.chunkedFetch = chunkedFetch;
exports.createChunkedFilters = createChunkedFilters;
exports.getPrebuiltRuleAssetSoId = getPrebuiltRuleAssetSoId;
exports.getPrebuiltRuleAssetsSearchNamespace = getPrebuiltRuleAssetsSearchNamespace;
exports.prepareQueryDslFilter = prepareQueryDslFilter;
exports.prepareQueryDslSort = prepareQueryDslSort;
var _pMap = _interopRequireDefault(require("p-map"));
var _lodash = require("lodash");
var _prebuilt_rule_assets_type = require("../prebuilt_rule_assets_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareQueryDslFilter(ruleIds, filter) {
  var _filter$fields, _filter$fields$name, _filter$fields$name$i, _filter$fields$tags, _filter$fields$tags$i;
  const queryFilter = [];
  if (ruleIds) {
    queryFilter.push({
      terms: {
        [`${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.rule_id`]: ruleIds
      }
    });
  }
  if (filter !== null && filter !== void 0 && (_filter$fields = filter.fields) !== null && _filter$fields !== void 0 && (_filter$fields$name = _filter$fields.name) !== null && _filter$fields$name !== void 0 && (_filter$fields$name$i = _filter$fields$name.include) !== null && _filter$fields$name$i !== void 0 && _filter$fields$name$i.values) {
    filter.fields.name.include.values.forEach(name => {
      queryFilter.push({
        wildcard: {
          [`${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.name.keyword`]: `*${name}*`
        }
      });
    });
  }
  if (filter !== null && filter !== void 0 && (_filter$fields$tags = filter.fields.tags) !== null && _filter$fields$tags !== void 0 && (_filter$fields$tags$i = _filter$fields$tags.include) !== null && _filter$fields$tags$i !== void 0 && _filter$fields$tags$i.values) {
    filter.fields.tags.include.values.forEach(tag => {
      queryFilter.push({
        term: {
          [`${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.tags`]: tag
        }
      });
    });
  }
  return queryFilter;
}
function prepareQueryDslSort(sort) {
  const soSortFields = {
    name: `${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.name.keyword`,
    severity: `${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.severity_rank`,
    risk_score: `${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.risk_score`
  };
  return sort === null || sort === void 0 ? void 0 : sort.map(s => {
    return {
      [soSortFields[s.field]]: s.order
    };
  });
}

/**
 * `savedObjectsClient.search` method requires a non-empty "namespaces" parameter even if you want to search for space-agnostic SO types.
 * This function returns the current namespace to be passed as "namespaces" parameter.
 */
function getPrebuiltRuleAssetsSearchNamespace(savedObjectsClient) {
  var _savedObjectsClient$g;
  return [(_savedObjectsClient$g = savedObjectsClient.getCurrentNamespace()) !== null && _savedObjectsClient$g !== void 0 ? _savedObjectsClient$g : 'default'];
}
function getPrebuiltRuleAssetSoId(ruleId, version) {
  return `${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}:${ruleId}_${version}`;
}

/**
 * Creates an array of KQL filter strings for a collection of items.
 * Uses chunking to ensure that the number of filter clauses does not exceed the ES "too_many_clauses" limit.
 * See: https://github.com/elastic/kibana/pull/223240
 *
 * @param {object} options
 * @param {T[]} options.items - Array of items to create filters for.
 * @param {(item: T) => string} options.mapperFn - A function that maps an item to a filter string.
 * @param {number} options.clausesPerItem - Number of Elasticsearch clauses generated per item. Determined empirically by converting a KQL filter into a Query DSL query.
 * More complex filters will result in more clauses. Info about clauses in docs: https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl#query-dsl
 * @returns {string[]} An array of filter strings
 */
function createChunkedFilters({
  items,
  mapperFn,
  clausesPerItem
}) {
  return (0, _lodash.chunk)(items, ES_MAX_CLAUSE_COUNT / clausesPerItem).map(singleChunk => singleChunk.map(mapperFn).join(' OR '));
}
const RULE_ASSET_ATTRIBUTES = exports.RULE_ASSET_ATTRIBUTES = `${_prebuilt_rule_assets_type.PREBUILT_RULE_ASSETS_SO_TYPE}.attributes`;
const ES_MAX_CLAUSE_COUNT = 1024;
const ES_MAX_CONCURRENT_REQUESTS = 2;

/**
 * Fetches objects using a provided function.
 * If filters are provided fetches concurrently in chunks.
 *
 * @param {(filter?: string) => Promise<T[]>} chunkFetchFn - Function that fetches a chunk.
 * @param {string[]} [filters] - An optional array of filter strings. If provided, `chunkFetchFn` will be called for each filter concurrently.
 * @returns {Promise<T[]>} A promise that resolves to an array of fetched objects.
 */
function chunkedFetch(chunkFetchFn, filters) {
  if (filters !== null && filters !== void 0 && filters.length) {
    return (0, _pMap.default)(filters, chunkFetchFn, {
      concurrency: ES_MAX_CONCURRENT_REQUESTS
    }).then(results => results.flat());
  }
  return chunkFetchFn();
}