"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrebuiltRuleAssetsClient = void 0;
var _with_security_span = require("../../../../../../utils/with_security_span");
var _fetch_latest_assets = require("./methods/fetch_latest_assets");
var _fetch_latest_versions = require("./methods/fetch_latest_versions");
var _fetch_assets_by_version = require("./methods/fetch_assets_by_version");
var _fetch_tags_by_version = require("./methods/fetch_tags_by_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrebuiltRuleAssetsClient = savedObjectsClient => {
  return {
    fetchLatestAssets: () => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleAssetsClient.fetchLatestAssets', async () => {
        return (0, _fetch_latest_assets.fetchLatestAssets)(savedObjectsClient);
      });
    },
    fetchLatestVersions: ({
      ruleIds,
      sort,
      filter
    } = {}) => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleAssetsClient.fetchLatestVersions', async () => {
        return (0, _fetch_latest_versions.fetchLatestVersions)(savedObjectsClient, {
          ruleIds,
          sort,
          filter
        });
      });
    },
    fetchAssetsByVersion: versions => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleAssetsClient.fetchAssetsByVersion', async () => {
        return (0, _fetch_assets_by_version.fetchAssetsByVersion)(savedObjectsClient, versions);
      });
    },
    fetchTagsByVersion: versions => {
      return (0, _with_security_span.withSecuritySpan)('IPrebuiltRuleAssetsClient.fetchTagsByVersion', async () => {
        return (0, _fetch_tags_by_version.fetchTagsByVersion)(savedObjectsClient, versions);
      });
    }
  };
};
exports.createPrebuiltRuleAssetsClient = createPrebuiltRuleAssetsClient;