"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeDedupedArrays = exports.getDedupedDataSourceVersion = void 0;
var _lodash = require("lodash");
var _detection_engine = require("../../../../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeDedupedArrays = (dedupedBaseVersion, dedupedCurrentVersion, dedupedTargetVersion) => {
  const addedCurrent = (0, _lodash.difference)(dedupedCurrentVersion, dedupedBaseVersion);
  const removedCurrent = (0, _lodash.difference)(dedupedBaseVersion, dedupedCurrentVersion);
  const addedTarget = (0, _lodash.difference)(dedupedTargetVersion, dedupedBaseVersion);
  const removedTarget = (0, _lodash.difference)(dedupedBaseVersion, dedupedTargetVersion);
  const bothAdded = (0, _lodash.union)(addedCurrent, addedTarget);
  const bothRemoved = (0, _lodash.union)(removedCurrent, removedTarget);
  return (0, _lodash.difference)((0, _lodash.union)(dedupedBaseVersion, bothAdded), bothRemoved);
};
exports.mergeDedupedArrays = mergeDedupedArrays;
const getDedupedDataSourceVersion = version => {
  if (version.type === _detection_engine.DataSourceType.index_patterns) {
    return {
      ...version,
      index_patterns: (0, _lodash.uniq)(version.index_patterns)
    };
  }
  return version;
};
exports.getDedupedDataSourceVersion = getDedupedDataSourceVersion;