"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reviewRuleInstallationRoute = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _review_rule_installation_route = require("../../../../../../common/api/detection_engine/prebuilt_rules/review_rule_installation/review_rule_installation_route");
var _route_limited_concurrency_tag = require("../../../../../utils/route_limited_concurrency_tag");
var _constants = require("../../constants");
var _review_rule_installation_handler = require("./review_rule_installation_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reviewRuleInstallationRoute = (router, logger) => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.REVIEW_RULE_INSTALLATION_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      tags: [(0, _route_limited_concurrency_tag.routeLimitedConcurrencyTag)(_constants.PREBUILT_RULES_INSTALLATION_REVIEW_CONCURRENCY)],
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(
        // If the request body is undefined, pass it as an empty object to the schema
        // to let the schema add default values.
        _zod.z.preprocess(data => data !== null && data !== void 0 ? data : {}, _review_rule_installation_route.ReviewRuleInstallationRequestBody))
      }
    }
  }, (context, request, response) => (0, _review_rule_installation_handler.reviewRuleInstallationHandler)(context, request, response, logger));
};
exports.reviewRuleInstallationRoute = reviewRuleInstallationRoute;