"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrebuiltRuleBaseVersion = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _get_prebuilt_rule_base_version_handler = require("./get_prebuilt_rule_base_version_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrebuiltRuleBaseVersion = router => {
  router.versioned.get({
    access: 'internal',
    path: _prebuilt_rules.GET_PREBUILT_RULES_BASE_VERSION_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_prebuilt_rules.GetPrebuiltRuleBaseVersionRequest)
      }
    }
  }, _get_prebuilt_rule_base_version_handler.getPrebuiltRuleBaseVersionHandler);
};
exports.getPrebuiltRuleBaseVersion = getPrebuiltRuleBaseVersion;