"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchFleetActionResponses = exports.fetchEndpointActionResponses = exports.fetchActionResponses = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _constants = require("../constants");
var _utils = require("../../../utils");
var _constants2 = require("../../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @internal */
const buildSearchQuery = (actionIds = [], agentIds = []) => {
  const filter = [];
  const query = {
    bool: {
      filter
    }
  };
  if (agentIds !== null && agentIds !== void 0 && agentIds.length) {
    filter.push({
      terms: {
        agent_id: agentIds
      }
    });
  }
  if (actionIds !== null && actionIds !== void 0 && actionIds.length) {
    filter.push({
      terms: {
        action_id: actionIds
      }
    });
  }
  return query;
};
/**
 * Fetch Response Action responses from both the Endpoint and the Fleet indexes
 */
const fetchActionResponses = async options => {
  const [fleetResponses, endpointResponses] = await Promise.all([fetchFleetActionResponses(options), fetchEndpointActionResponses(options)]);
  return {
    fleetResponses,
    endpointResponses
  };
};

/**
 * Fetch Response Action response documents from the Endpoint index
 * @param esClient
 * @param actionIds
 * @param agentIds
 */
exports.fetchActionResponses = fetchActionResponses;
const fetchEndpointActionResponses = async ({
  esClient,
  actionIds,
  agentIds
}) => {
  var _searchResponse$hits$, _searchResponse$hits;
  const searchResponse = await esClient.search({
    index: _constants2.ENDPOINT_ACTION_RESPONSES_INDEX_PATTERN,
    size: _constants.ACTIONS_SEARCH_PAGE_SIZE,
    query: buildSearchQuery(actionIds, agentIds)
  }, {
    ignore: [404]
  }).catch(_utils.catchAndWrapError);
  return ((_searchResponse$hits$ = searchResponse === null || searchResponse === void 0 ? void 0 : (_searchResponse$hits = searchResponse.hits) === null || _searchResponse$hits === void 0 ? void 0 : _searchResponse$hits.hits) !== null && _searchResponse$hits$ !== void 0 ? _searchResponse$hits$ : []).map(esHit => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return esHit._source;
  });
};

/**
 * Fetch Response Action response documents from the Fleet index
 * @param esClient
 * @param actionIds
 * @param agentIds
 */
exports.fetchEndpointActionResponses = fetchEndpointActionResponses;
const fetchFleetActionResponses = async ({
  esClient,
  actionIds,
  agentIds
}) => {
  var _searchResponse$hits$2, _searchResponse$hits2;
  const searchResponse = await esClient.search({
    index: _common.AGENT_ACTIONS_RESULTS_INDEX,
    size: _constants.ACTIONS_SEARCH_PAGE_SIZE,
    query: buildSearchQuery(actionIds, agentIds)
  }, {
    ignore: [404]
  }).catch(_utils.catchAndWrapError);
  return ((_searchResponse$hits$2 = searchResponse === null || searchResponse === void 0 ? void 0 : (_searchResponse$hits2 = searchResponse.hits) === null || _searchResponse$hits2 === void 0 ? void 0 : _searchResponse$hits2.hits) !== null && _searchResponse$hits$2 !== void 0 ? _searchResponse$hits$2 : []).map(esHit => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return esHit._source;
  });
};
exports.fetchFleetActionResponses = fetchFleetActionResponses;