"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompleteExternalResponseActionsTask = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_VERSION = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TITLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _errors = require("../../../../common/endpoint/errors");
var _complete_external_actions_task_runner = require("./complete_external_actions_task_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE = 'endpoint:complete-external-response-actions';
const COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_VERSION = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_VERSION = '1.0.0';
const COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TITLE = exports.COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TITLE = 'Security Solution Complete External Response Actions';
class CompleteExternalResponseActionsTask {
  // Default. Real value comes from server config

  constructor(options) {
    (0, _defineProperty2.default)(this, "wasSetup", false);
    (0, _defineProperty2.default)(this, "wasStarted", false);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "esClient", undefined);
    (0, _defineProperty2.default)(this, "cleanup", void 0);
    (0, _defineProperty2.default)(this, "taskTimeout", '5m');
    // Default. Real value comes from server config
    (0, _defineProperty2.default)(this, "taskInterval", '60s');
    this.options = options;
    this.log = this.options.endpointAppContext.logFactory.get(COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE);
  }
  get taskId() {
    return `${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE}-${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_VERSION}`;
  }
  setup({
    taskManager
  }) {
    var _this$options$endpoin, _this$options$endpoin2;
    if (this.wasSetup) {
      throw new Error(`Task has already been setup!`);
    }
    this.wasSetup = true;
    if (!this.options.endpointAppContext.experimentalFeatures.responseActionsSentinelOneV2Enabled) {
      this.log.info(`responseActionsSentinelOneV2Enabled feature flag is disabled. Task [${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE}] will NOT be registered!`);
      return;
    }
    this.taskInterval = (_this$options$endpoin = this.options.endpointAppContext.serverConfig.completeExternalResponseActionsTaskInterval) !== null && _this$options$endpoin !== void 0 ? _this$options$endpoin : this.taskInterval;
    this.taskTimeout = (_this$options$endpoin2 = this.options.endpointAppContext.serverConfig.completeExternalResponseActionsTaskTimeout) !== null && _this$options$endpoin2 !== void 0 ? _this$options$endpoin2 : this.taskTimeout;
    this.log.info(`Registering task [${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE}] with timeout of [${this.taskTimeout}] and run interval of [${this.taskInterval}]`);
    taskManager.registerTaskDefinitions({
      [COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE]: {
        title: COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TITLE,
        timeout: this.taskTimeout,
        createTaskRunner: ({
          taskInstance
        }) => {
          if (!this.esClient) {
            throw new _errors.EndpointError(`esClient not defined. Was [${this.constructor.name}.start()] called?`);
          }
          const {
            id: taskId,
            taskType
          } = taskInstance;
          return new _complete_external_actions_task_runner.CompleteExternalActionsTaskRunner(this.options.endpointAppContext.service, this.esClient, this.taskInterval, taskId, taskType);
        }
      }
    });
  }
  async start({
    taskManager,
    esClient
  }) {
    if (this.wasStarted) {
      throw new Error('Task has already been started!');
    }
    this.wasStarted = true;
    this.esClient = esClient;
    if (!this.options.endpointAppContext.experimentalFeatures.responseActionsSentinelOneV2Enabled) {
      return;
    }
    try {
      await taskManager.ensureScheduled({
        id: this.taskId,
        taskType: COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE,
        scope: ['securitySolution'],
        schedule: {
          interval: this.taskInterval
        },
        state: {},
        params: {}
      });
    } catch (e) {
      this.log.error(new _errors.EndpointError(`Error scheduling task, received: ${e.message}`, e));
    }
    this.cleanup = () => {
      this.log.info(`Un-registering task definition [${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE}] (if it exists)`);
      taskManager.removeIfExists(COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE).catch(() => {});
      this.cleanup = undefined;
    };
  }
  async stop() {
    this.wasSetup = false;
    this.wasStarted = false;
    if (this.cleanup) {
      this.cleanup();
      this.cleanup = undefined;
    }
    this.log.debug(`Task [${COMPLETE_EXTERNAL_RESPONSE_ACTIONS_TASK_TYPE}] as been stopped`);
  }
}
exports.CompleteExternalResponseActionsTask = CompleteExternalResponseActionsTask;